
#include <plib.h>
#include "WM8731.h"

#define IOPORT_CS   IOPORT_F // CS = RF1
#define BIT_CS      BIT_1
#define IOPORT_MOSI IOPORT_D // MOSI = RD0
#define BIT_MOSI    BIT_0
#define IOPORT_SCK  IOPORT_C // SCK = RC13
#define BIT_SCK     BIT_13

void WM8731_Setup_Control_SPI() {
    PORTSetBits(IOPORT_CS, BIT_CS);
    PORTSetPinsDigitalOut(IOPORT_CS, BIT_CS);
    PORTSetPinsDigitalOut(IOPORT_MOSI, BIT_MOSI);
    PORTSetPinsDigitalOut(IOPORT_SCK, BIT_SCK);
}

void WM8731_Send_Control_SPI_Message(unsigned short data) {
    unsigned char bitnum = 16;
    PORTClearBits(IOPORT_CS, BIT_CS);
    do {
        PORTClearBits(IOPORT_SCK, BIT_SCK);
        if( data&0x8000 )
            PORTSetBits(IOPORT_MOSI, BIT_MOSI);
        else
            PORTClearBits(IOPORT_MOSI, BIT_MOSI);
        Nop();
        Nop();
        Nop();
        Nop();
        PORTSetBits(IOPORT_SCK, BIT_SCK);
        data <<= 1;
    } while( --bitnum );
    Nop();
    Nop();
    PORTSetBits(IOPORT_CS, BIT_CS);
    PORTSetBits(IOPORT_MOSI, BIT_MOSI);
}

void WM8731_Set_Left_Line_In_Vol(signed short dB, boolean mute, boolean lrinboth) {
    if( dB > 12 )
        dB = 12;
    else if( dB < -35 )
        dB = -35;
    WM8731_Send_Control_SPI_Message(0x0000|(dB * 2 / 3 + 23)|(mute ? 128 : 0)|(lrinboth ? 256 : 0));
}

void WM8731_Set_Right_Line_In_Vol(signed short dB, boolean mute, boolean lrinboth) {
    if( dB > 12 )
        dB = 12;
    else if( dB < -35 )
        dB = -35;
    WM8731_Send_Control_SPI_Message(0x0002|(dB * 2 / 3 + 23)|(mute ? 128 : 0)|(lrinboth ? 256 : 0));
}

void WM8731_Set_Left_Headphone_Out_Vol(signed short dB, boolean zcen, boolean lrhpboth) {
    if( dB > 6 )
        dB = 6;
    else if( dB < -74 )
        dB = -74;
    WM8731_Send_Control_SPI_Message(0x0400|(dB + 121)|(zcen ? 128 : 0)|(lrhpboth ? 256 : 0));
}

void WM8731_Set_Right_Headphone_Out_Vol(signed short dB, boolean zcen, boolean lrhpboth) {
    if( dB > 6 )
        dB = 6;
    else if( dB < -74 )
        dB = -74;
    WM8731_Send_Control_SPI_Message(0x0600|(dB + 121)|(zcen ? 128 : 0)|(lrhpboth ? 256 : 0));
}

void WM8731_Set_Analog_Audio_Path(boolean micboost, boolean micmute, WM8731_Input_To_ADC adc_input, boolean bypass_enable, boolean dac_enable, boolean sidetone_enable, signed char sidetone_atten_db) {
    if( sidetone_atten_db > -6 )
        sidetone_atten_db = -6;
    else if( sidetone_atten_db < -15 )
        sidetone_atten_db = -15;
    WM8731_Send_Control_SPI_Message(0x0800|(micboost ? 1 : 0)|(micmute ? 2 : 0)|(adc_input == Microphone ? 4 : 0)|(bypass_enable ? 8 : 0)|(dac_enable ? 16 : 0)|(sidetone_enable ? 32 : 0)|((-sidetone_atten_db / 3 - 2)<<6));
}

void WM8731_Set_Digital_Audio_Path(boolean adc_high_pass_filter_enable, unsigned short deemphasis_sampling_rate, boolean dac_soft_mute_enable, boolean high_pass_filter_disabled_store_dc_offset) {
    unsigned char deemp;
    switch(deemphasis_sampling_rate) {
        case 32000:
            deemp = 2;
            break;
        case 44100:
            deemp = 4;
            break;
        case 48000:
            deemp = 6;
            break;
        default://0 = off
            deemp = 0;
            break;
    }
    WM8731_Send_Control_SPI_Message(0x0A00|(adc_high_pass_filter_enable ? 1 : 0)|deemp|(dac_soft_mute_enable ? 8 : 0)|(high_pass_filter_disabled_store_dc_offset ? 16 : 0));
}

void WM8731_Power_Control(boolean enable_line_input, boolean enable_mic_input_bias, boolean enable_adc, boolean enable_dac, boolean enable_outputs, boolean enable_oscillator, boolean enable_clkout, boolean poweroff) {
    WM8731_Send_Control_SPI_Message(0x0C00|(enable_line_input ? 0 : 1)|(enable_mic_input_bias ? 0 : 2)|(enable_adc ? 0 : 4)|(enable_dac ? 0 : 8)|(enable_outputs ? 0 : 16)|(enable_oscillator ? 0 : 32)|(enable_clkout ? 0 : 64)|(poweroff ? 128 : 0));
}

void WM8731_Set_Digital_Audio_Interface_Format(WM8731_Digital_Audio_Format format, unsigned char data_bit_length, WM8731_Left_Right_Phase lrp, boolean dac_left_right_swap, WM8731_Mode mode, boolean invert_bclk) {
    unsigned char iwl;
    switch(data_bit_length) {
        case 20:
            iwl = 4;
            break;
        case 24:
            iwl = 8;
            break;
        case 32:
            iwl = 12;
            break;
        default://16
            iwl = 0;
            break;
    }
    WM8731_Send_Control_SPI_Message(0x0E00|format|iwl|(lrp ? 16 : 0)|(dac_left_right_swap ? 32 : 0)|(mode == Master_Mode ? 64 : 0)|(invert_bclk ? 128 : 0));
}

void WM8731_Sampling_Control(unsigned short oversampling_rate, unsigned long adc_sampling_rate, unsigned long dac_sampling_rate, boolean mclk_divide_by_two, boolean clkout_divide_by_two) {
    unsigned char osr, sr;
    switch(oversampling_rate) {
        case 250:
            osr = 1;
            break;
        case 272:
            osr = 3;
            break;
        case 384:
            osr = 2;
            break;
        default://256
            osr = 0;
            break;
    }
    switch(adc_sampling_rate) {
        default://48000
            switch(dac_sampling_rate) {
                case 8000:
                    sr = 4;
                    break;
                default://48000
                    sr = 0;
                    break;
            }
            break;
        case 8000:
            switch(dac_sampling_rate) {
                case 48000:
                    sr = 8;
                    break;
                default://8000
                    sr = 12;
                    break;
            }
            break;
        case 8018:
            switch(dac_sampling_rate) {
                case 44100:
                    sr = 40;
                    break;
                default://8018
                    sr = 44;
                    break;
            }
            break;
        case 32000:
            sr = 24;
            break;
        case 96000:
            sr = 28;
            break;
        case 44100:
             switch(dac_sampling_rate) {
                case 8018:
                    sr = 36;
                    break;
                default://44100
                    sr = 32;
                    break;
            }
           break;
        case 88200:
            sr = 60;
            break;
    }
    WM8731_Send_Control_SPI_Message(0x1000|osr|sr|(mclk_divide_by_two ? 64 : 0)|(clkout_divide_by_two ? 128 : 0));
}

void WM8731_Enable_MCU_Interface(boolean enable) {
    WM8731_Send_Control_SPI_Message(0x1200|(enable ? 1 : 0));
}
void WM8731_Reset() {
    WM8731_Send_Control_SPI_Message(0x1E00);
}
